unit ScrollBarMargin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ScrollBarMargin
// Property: Forms.TControlScrollBar.Margin
// Property: Forms.TControlScrollBar.Range

// BeginCode
{
This example uses a button and a label on a form and needs
the AutoScroll property set on the form. Place the label
near the left side of the form, and place the button
somewhere near the middle of the form. When the user runs
the application, a horizontal scroll bar does not appear,
because no control on the form is close enough to the right
edge.  Each time the user clicks the button, the button moves
25 pixels to the right, and the calculated Range value is
reported in the caption of the label. Repeatedly clicking the
button eventually moves the button close enough to the edge
of the form (within the Margin amount) so that a horizontal 
scroll bar appears.  Note that the Range property is 
continuously updated as the button moves to the right.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  with HorzScrollBar do
  begin
    Margin:= 25;
    Increment := 10;
    Visible := True;
  end;
end;
procedure TForm1.Button1Click(Sender: TObject);
begin
  Button1.Left := Button1.Left + 25;
  Label1.Caption := IntToStr(HorzScrollBar.Range);
end;
// EndCode
// EndExample: ScrollBarMargin
end.
