{
SetFocus, SelStart, SelLength example
The following OnFind event handler searches a memo component for the text specified in the FindText property of a find dialog component. If found, the first occurrence of the text in Memo1 is selected. The code uses the Pos function to compare strings, and stores the number of characters to skip when determining the selection position in the SkipChars variable. Because there is no handling of case, whole word, or search direction in this algorithm, it is assumed that the Options property of FindDialog1 was set to [frHideMatchCase, frHideWholeWord, frHideUpDown].
} 
procedure TForm1.FindDialog1Find(Sender: TObject);
var
  I, J, PosReturn, SkipChars: Integer;
begin
  for I := 0 to Memo1.Lines.Count do
  begin
    PosReturn := Pos(FindDialog1.FindText,Memo1.Lines[I]);
    if PosReturn <> 0 then {found!}
    begin
      SkipChars := 0;
      for J := 0 to I - 1 do
        SkipChars := SkipChars + Length(Memo1.Lines[J]);
      SkipChars := SkipChars + (I*2);
      SkipChars := SkipChars + PosReturn - 1;
      Memo1.SetFocus;
      Memo1.SelStart := SkipChars;
      Memo1.SelLength := Length(FindDialog1.FindText);
      Break;
    end;
  end;
end; 
