unit SelText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SelText
// Method: StdCtrls.TCustomEdit.GetSelTextBuf
// Property: StdCtrls.TCustomEdit.SelText

// BeginCode
{
This example copies selected text from one text edit to
another.  This example requires two text edits and two buttons.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  Buffer: PChar;
  Size: Integer;
begin
  Size := Edit1.SelLength; {Get length of selected text in Edit1}
  Inc(Size); {Add room for null character}
  GetMem(Buffer, Size); {Creates Buffer dynamic variable}
  Edit1.GetSelTextBuf(Buffer,Size); {Puts Edit1.Text into Buffer}
  Edit2.Text := StrPas(Buffer);{Converts Buffer into Pascal-style string}
  FreeMem(Buffer, Size);{Frees memory allocated to Buffer}
end;

{
Note: the same thing could be accomplished more simply as follows:
} 
procedure TForm1.Button2Click(Sender: TObject);
begin
  Edit2.Text := Edit1.SelText;
end;
// EndCode
// EndExample: SelText
end.
