unit SelectDirectory;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SelectDirectory
// Routine: FileCtrl.SelectDirectory
// Type: FileCtrl.TSelectDirOpt

// BeginCode
{
This example uses a button and a label on a form. When the
user clicks the button, a Select Directory dialog box
appears. The current directory displayed in the dialog box
is C:\WINDOWS. The user can select a directory from the
directory list, or enter a new directory in the edit box. If
the user enters a new directory, a message box asks the user
if the directory should be created. If the user chooses Yes,
the directory is created. If the user chooses No, the message
box goes away without creating the directory. The name of the
directory the user selects appears as the caption of the label:
} 
uses FileCtrl;
const
  SELDIRHELP = 1000;
procedure TForm1.Button1Click(Sender: TObject);
var
  Dir: string;
begin
  Dir := 'C:\Windows';
  if FileCtrl.SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt],SELDIRHELP) then
    Label1.Caption := Dir;
end;
// EndCode
// EndExample: SelectDirectory
end.
