unit MessagesExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

// BeginExample: Messages
// Routine: Messages.SendGetIntMessage
// Routine: Messages.SendStructMessage
// Routine: Messages.SendGetStructMessage
// Routine: Messages.SendTextMessage

// Warning: Bruneau's thunks

// BeginCode
{
This is an example demonstrating the usage of the SendGetIntMessage,
SendStructMessage, SendGetStructMessage and SendTextMessage message
functions.
This example uses four buttons and six text edit boxes as follows:
- Button1 //SendGetIntMessage
- Button2 //SendStructMessage
- Button3 //SendGetStructMessage
- Button4 //SendTextMessage

- IntEdit //for int inputs
- StructEdit1 & StructEdit2 //for struct inputs (ints)
- GetStructEdit1 & GetStructEdit2 //for struct inputs (ints)
- TextEdit //for text input
}


const
  WM_INTMSG = WM_USER + 100;
  WM_STRUCTMSG = WM_USER + 101;
  WM_GETSTRUCTMSG = WM_USER + 102;
  WM_TEXTMSG = WM_USER + 103;


type
  TMyIntMessage = packed record
    Msg: Cardinal;
    WParam: ^Integer;
    LParam: ^Integer;
    Result: LRESULT;
  end;

  TMyTextMessage = packed record
    Msg: Cardinal;
    WParam: Integer;
    LParam: String;
    Result: LRESULT;
  end;

  MStruct = packed record
    m_a : Integer;
    m_b : Integer;
  end;

  TMyStruct = packed record
    Msg : Cardinal;
    WParam : Integer;
    LParam : ^MStruct;
    Result : LRESULT;
  end;

  TForm4 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    IntEdit: TEdit;
    StructEdit1: TEdit;
    GetStructEdit1: TEdit;
    TextEdit: TEdit;
    StructEdit2: TEdit;
    GetStructEdit2: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure UserIntHandler(var msg: TMyIntMessage); message WM_INTMSG;

    procedure UserStructHandler(var msg: TMyStruct); message WM_STRUCTMSG;

    procedure UserGetStructHandler(var msg: TMyStruct); message WM_GETSTRUCTMSG;

    procedure UserTextHandler(var msg: TMyTextMessage); message WM_TEXTMSG;

  end;

var
  Form4: TForm4;

implementation

{$R *.dfm}

{ TForm4 }

procedure TForm4.Button1Click(Sender: TObject);
var
  wparam : Integer;
  lparam, lbase : Integer;
begin
  //SendGetIntMessage
  wparam := 0;

  lparam := StrToIntDef(IntEdit.Text,0);
  lbase := lparam;

  SendGetIntMessage(Handle, WM_INTMSG, wparam, lparam);

  if lbase <> lparam then
  begin
  MessageDlg('Value modified by handler function: ' + IntToStr(lparam),
              mtInformation, [mbOK], 0);
  IntEdit.Text := IntToStr(lparam);
  end;
end;

procedure TForm4.Button2Click(Sender: TObject);
var
  wparam : Integer;
  lparam : MStruct;
begin
  //SendStructMessage
  wparam := 0;

  lparam.m_a := StrToIntDef(StructEdit1.Text,0);
  lparam.m_b := StrToIntDef(StructEdit2.Text,0);

  SendStructMessage(Handle, WM_STRUCTMSG, wparam, lparam);
end;

procedure TForm4.Button3Click(Sender: TObject);
var
  wparam : Integer;
  lparam, lbase : MStruct;
begin
  //SendGetStructMessage
  wparam := 0;

  lparam.m_a := StrToIntDef(GetStructEdit1.Text,0);
  lparam.m_b := StrToIntDef(GetStructEdit2.Text,0);

  lbase := lparam;

  SendGetStructMessage(Handle, WM_GETSTRUCTMSG, wparam, lparam);

  if lbase.m_a <> lparam.m_a then
  begin
  MessageDlg('Struct modified by handler function: ' +
              IntToStr(lparam.m_a) + ' ' + IntToStr(lparam.m_b),
              mtInformation, [mbOK], 0);
  GetStructEdit1.Text := IntToStr(lparam.m_a);
  GetStructEdit2.Text := IntToStr(lparam.m_b);
  end;

end;

procedure TForm4.Button4Click(Sender: TObject);
var
  wparam : Integer;
  lparam : UnicodeString;
begin
  //SendTextMessage
  wparam := 0;

  lparam := TextEdit.Text;

  SendTextMessage(Handle, WM_TEXTMSG, wparam, lparam);

end;

procedure TForm4.UserGetStructHandler(var msg: TMyStruct);
begin
  MessageDlg('Struct msg received: ' + IntToStr(msg.LParam^.m_a) +
           ' '  + IntToStr(msg.LParam^.m_b), mtInformation, [mbOK], 0);
  msg.LParam^.m_a := msg.LParam^.m_a + 50;
  msg.LParam^.m_b := msg.LParam^.m_b + 50;
end;

procedure TForm4.UserIntHandler(var msg: TMyIntMessage);
begin
  MessageDlg('Int msg received: ' + IntToStr(msg.LParam^),
              mtInformation, [mbOK], 0);

  msg.LParam^ := msg.LParam^ + 50;
end;

procedure TForm4.UserStructHandler(var msg: TMyStruct);
begin
  MessageDlg('Struct msg received: ' + IntToStr(msg.LParam^.m_a) +
           ' '  + IntToStr(msg.LParam^.m_b), mtInformation, [mbOK], 0);
end;

procedure TForm4.UserTextHandler(var msg: TMyTextMessage);
begin
  MessageDlg('Text msg received: ' + msg.LParam,
              mtInformation, [mbOK], 0);
end;

// EndCode
// EndExample: Messages

end.
