unit Set8087CW;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    RadioGroup1: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

// BeginExample: Set8087CW
// Routine: System.Set8087CW
// Variable: System.Default8087CW

// BeginCode
{
This example accesses the Floating Point Unit (FPU) control
register.  Try turning floating point exceptions off and on
and dividing a number by zero to test it.
}
var
  Form1: TForm1;
  Saved8087CW: Word;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Edit3.Text := FloatToStr(StrToFloat(Edit1.Text) / StrToFloat(Edit2.Text));
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  if RadioGroup1.Items[RadioGroup1.ItemIndex] = 'FPU Exceptions' then
    System.Set8087CW(Saved8087CW);
  if RadioGroup1.Items[RadioGroup1.ItemIndex] = 'No FPU Exceptions' then
    System.Set8087CW($133f); { Disable all fpu exceptions }
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  RadioGroup1.Items.Add('No FPU Exceptions');
  RadioGroup1.Items.Add('FPU Exceptions');
  RadioGroup1.ItemIndex := 2;
  Saved8087CW := Default8087CW;  // Save this because Set8087CW changes it!
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  System.Set8087CW(Saved8087CW); // Default value (with exceptions) is $1372
end;
// EndCode
// EndExample: Set8087CW
end.
