unit SetEnumPropExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, TypInfo;

type
  TForm3 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}
// BeginExample: SetEnumProp
// Routine: TypInfo.SetEnumProp
// Routine: TypInfo.GetEnumProp

// BeginCode
{
This example shows how to use GetEnumProp and SetEnumProp in order to
check for visual components properties and to change them.
This example uses two buttons, Button1 and Button2.
}
procedure TForm3.Button1Click(Sender: TObject);
var
  currentPropColor : String;
  currentAlignProp : String;
  currentColorInt : Integer;
begin
  //getting the current color of the workspace
  currentPropColor := GetEnumProp(Self,'Color');
  currentColorInt := StrToInt(currentPropColor);

  //getting the first button align enum and if different,
  //setting it to alLeft
  currentAlignProp := GetEnumProp(Button1, 'Align');
  if GetEnumValue(TypeInfo(TAlign), currentAlignProp) <> Ord(alLeft) then
     SetEnumProp(Button1, 'Align', 'alLeft');

  //checking if the form background color was set.
	if currentColorInt < 0 then
    begin
		currentColorInt := GetSysColor(COLOR_APPWORKSPACE);
    end;

  //setting the form background color as the negative value
  // of the current background color
  currentColorInt := clWhite - currentColorInt;

  SetEnumProp(Self, 'Color', IntToStr(currentColorInt));
end;

procedure TForm3.Button2Click(Sender: TObject);
var
  p : array [0..4] of Integer;
  currentAlignProp : String;
begin
  p[0] := clYellow;
  p[1] := clRed;
  p[2] := clBlue;
  p[3] := clBlack;
  p[4] := clGreen;

	SetEnumProp(Self, 'Color', IntToStr(p[random(5)]));

  //getting the second button align enum and if different,
  //setting it to alRight
  currentAlignProp := GetEnumProp(Button2, 'Align');
  if GetEnumValue(TypeInfo(TAlign), currentAlignProp) <> Ord(alRight) then
     SetEnumProp(Button2, 'Align', 'alRight');

end;
// EndCode
// EndExample: SetEnumProp
end.
