unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TOptionsForm = class(TForm)
    cbYes: TCheckBox;
    cbNo: TCheckBox;
    btShowMessage: TButton;
    cbCancel: TCheckBox;
    procedure btShowMessageClick(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
  private
    { Private declarations }
    FMsgButtons: TMsgDlgButtons;
  public
    { Public declarations }
  end;

var
 OptionsForm: TOptionsForm;

implementation

{$R *.dfm}

// BeginExample: SetIncludeExclude
// Routine: System.Include
// Routine: System.Exclude

// BeginCode
{
This example demonstrates the use of Include and Exclude routines.
The example assumes a form with three checkboxes and a button. Also
a field called FMsgButtons of type TMsgDlgButtons is declared in the form.
}
procedure TOptionsForm.btShowMessageClick(Sender: TObject);
begin
  //Creates a Message Dialog with the Selected Buttons
  MessageDlg('Hello World!', mtInformation, FMsgButtons, 0);
end;

procedure TOptionsForm.CheckBoxClick(Sender: TObject);
begin
  { Check wether an option is selected and add an element into a set,
    or exclude it from the set}

  if cbYes.Checked then
    Include(FMsgButtons, mbYes)
  else
    Exclude(FMsgButtons, mbYes);

  if cbNo.Checked then
    Include(FMsgButtons, mbNo)
  else
    Exclude(FMsgButtons, mbNo);

  if cbCancel.Checked then
    Include(FMsgButtons, mbCancel)
  else
    Exclude(FMsgButtons, mbCancel);
end;
// EndCode
// EndExample: SetIncludeExclude

end.
