unit SetTextBuf;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SetTextBuf
// Routine: System.SetTextBuf

// BeginCode
{
This example reads a file into a buffer and then dumps
the buffer into a new file WOOF.DOG
}
procedure TForm1.Button1Click(Sender: TObject);
var
  F, FTwo: System.TextFile;
  Ch: Char;
  Buf: array[1..4096] of Char;  { 4K buffer }
begin
  if OpenDialog1.Execute then
  begin
    AssignFile(F, OpenDialog1.FileName);
    { Larger buffer for faster reads }
    System.SetTextBuf(F, Buf);
    Reset(F);
    { Dump text file into another file }
    AssignFile(FTwo, 'WOOF.DOG');
    Rewrite(FTwo);
    while not Eof(f) do
    begin
      Read(F, Ch);
      Write(FTwo, Ch);
    end;
    System.CloseFile(F);
    System.CloseFile(FTwo);
  end;
// EndCode
// EndExample: SetTextBuf
end;

end.
