unit ShortCutToKey;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    FileCommand: TMenuItem;
    CloseCommand: TMenuItem;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure CloseCommandClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ShortCutToKey
// Routine: Menus.ShortCutToKey

// BeginCode
{
The following code redefines the ShortCut of CloseCommand if
the original short cut used the [ssCtrl] shift state.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  TheKey: Word;
  TheShiftState: TShiftState;
begin
  Menus.ShortCutToKey(CloseCommand.ShortCut, TheKey, TheShiftState);
  if TheShiftState = [ssCtrl] then
   CloseCommand.ShortCut := ShortCut(Word('C'), [ssShift]);
end;

procedure TForm1.CloseCommandClick(Sender: TObject);
begin
  MessageDlg('The Close command has been selected.', mtInformation, [mbOk], 0);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  CloseCommand.ShortCut := Menus.ShortCut(Word('C'), [ssCtrl]);
end;
// EndCode
// EndExample: ShortCutToKey
end.
