unit ShortCutToText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    FileCommand: TMenuItem;
    OpenCommand: TMenuItem;
    Edit1: TEdit;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure OpenCommandClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ShortCutToText
// Routine: Menus.ShortCutToText

// BeginCode
{
This line creates a shortcut, Ctrl+O, at run time and
assigns it to the Open command on a File menu.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  Edit1.Text := Menus.ShortCutToText(OpenCommand.ShortCut);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenCommand.ShortCut := Menus.ShortCut(Word('O'), [ssCtrl]);
end;

procedure TForm1.OpenCommandClick(Sender: TObject);
begin
  MessageDlg('The Open command has been selected.', mtInformation, [mbOk], 0);
end;
// EndCode
// EndExample: ShortCutToText
end.
