unit ShowException;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  EPasswordInvalid = class(Exception);
  TForm1 = class(TForm)
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure AppException(Sender: TObject; E: Exception);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ShowException
// Method: Forms.TApplication.ShowException
// Event: Forms.TApplication.OnException
// Method: Forms.TApplication.Terminate
// Method: SysUtils.Exception.Create

// BeginCode
{
In addition to displaying the exception message, which 
happens by default, the following code shuts down the 
application when an exception is not caught and handled.  
AppException should be declared a method of TForm1.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnException := AppException;
end;

procedure TForm1.AppException(Sender: TObject; E: Exception);
begin
  Application.ShowException(E);
  Application.Terminate;
end; 

procedure TForm1.Button1Click(Sender: TObject);
begin
  raise EPasswordInvalid.Create('Incorrect password entered');
end;
// EndCode
// EndExample: ShowException
end.
