unit ShowHint;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ShowHint
// Property: Forms.TApplication.ShowHint
// Property: Forms.TApplication.Hint
// Property: Controls.TControl.ShowHint
// Property: Controls.TControl.Hint

// BeginCode
{
This example uses an edit box and a list box on a form.  
Items are added to the list box and a Help Hint is assigned 
to both controls. The last statement enables the Help Hints
for the entire application.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  Edit1.Hint := 'Enter your name';
  Edit1.ShowHint := True;
  with ListBox1 do
  begin
    for I := 1 to 10 do
      Items.Add('Item ' + IntToStr(I));
    Hint := 'Select an item';
    ShowHint := True;
  end;
  Application.ShowHint := True;
end;
{
Note: To see an example that displays the hints of controls
in some place other than in a Help Hint box, see the OnHint
example.
}
// EndCode
// EndExample: ShowHint
end.
