unit SimplePanel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SimplePanelProperty
// Property: ComCtrls.TCustomStatusBar.SimplePanel
// Property: ComCtrls.TCustomStatusBar.SimpleText
// Method: Classes.TStrings.Add

// BeginCode
{
This example adds text to a TRichEdit and to a StatusBar.
This example requires no additional controls. All controls are
created dynamically within the form's OnCreate event handler.
Note: Be sure to add ComCtrls to your uses clause to support 
TRichEdit.
}
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  with TStatusBar.Create(Self) do
  begin
    // Display the StatusBar control on the surface
    // of the form.
    Parent := Self;
    // Allow a single line of text -- no panels.
    SimplePanel := True;
    // Provide sample text.
    // Create a new instance of TRichEdit, set its
    // properties, and display on the form.
    with TRichEdit.Create(Self) do
    begin
      // Display the RichEdit control on the surface
      // of the form.
      Parent := Self;
      // The RichText control takes all space left
      // over from the StatusBar.
      Align := alClient;
      // Add 50 lines to the RichText
      for i := 1 to 50 do
        Lines.Add('Adding line ' + IntToStr(i));
      SelStart := 0; // set text cursor to first character
      SimpleText := 'Number of Lines loaded to RichText: ' +
        IntToStr(Lines.Count);
    end;
  end;
end;
// EndCode
// EndExample: SimplePanelProperty
end.
