{
SimplePanel, SimpleText, Add example
This example requires no additional controls. All controls are created dynamically within the form's OnCreate event handler.
Note: Be sure to add ComCtrls (Windows) or QStdCtrls (cross-platform) to your uses clause to support TRichEdit or TMemo.
On Windows:
}
uses ComCtrls;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  with TStatusBar.Create(Self) do
  begin
    // Display the StatusBar control on the surface
    // of the form.
    Parent := Self;
    // Allow a single line of text -- no panels.
    SimplePanel := True;
    // Provide sample text.
    // Create a new instance of TRichEdit, set its
    // properties, and display on the form.
    with TRichEdit.Create(Self) do
    begin
      // Display the RichEdit control on the surface
      // of the form.
      Parent := Self;
      // The RichText control takes all space left
      // over from the StatusBar.
      Align := alClient;
      // Add 50 lines to the RichText
      for i := 1 to 50 do
        Lines.Add('Adding line ' + IntToStr(i));
      SelStart := 0; // set text cursor to first character
      SimpleText := 'Number of Lines loaded to RichText: ' +
        IntToStr(Lines.Count);
    end;
  end;
end;
On Cross-platform:
uses QStdCtrls;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  with TStatusBar.Create(Self) do
  begin
    // Display the StatusBar control on the surface
    // of the form.
    Parent := Self;
    // Allow a single line of text -- no panels.
    SimplePanel := True;
    // Provide sample text.
    // Create a new instance of TMemo, set its
    // properties, and display on the form.
    with TMemo.Create(Self) do
    begin
      // Display the memo control on the surface
      // of the form.
      Parent := Self;
      // The memo control takes all space left
      // over from the StatusBar.
      Align := alClient;
      // Add 50 lines to the memo
      for i := 1 to 50 do
        Lines.Add('Adding line ' + IntToStr(i));
      SelStart := 0; // set text cursor to first character
      SimpleText := 'Number of Lines loaded to memo: ' +
        IntToStr(Lines.Count);
    end;
  end;
end;
 
