{
Splitter Example
This example shows how to use a splitter to divide a form into resizable panes.  All objects on the form are created dynamically in the OnCreate event handler of the form. To run this example, add ExtCtrls and FileCtrl to the uses clause of the forms implementation section.
Note that when creating a splitter dynamically at runtime, it is important to set its position to the appropriate side of the control it will resize.
} 
procedure TForm1.Form1Create(Sender: TObject);
var
  Split: TSplitter;
  Files: TFileListBox;
  Dirs: TDirectoryListBox;
begin
  { first add a directory list box to the form }
  Dirs := TDirectoryListBox.Create(Form1);
  { line it up on the left of the form }
  Dirs.Parent := Form1;
  Dirs.Align := alLeft;
  Dirs.Width := Form1.ClientWidth div 3;
{ now add the splitter to divide the directory pane from the file pane }
  Split := TSplitter.Create(Form1);
  Split.Parent := Form1;
  { make sure the splitter is to the right of the directory list box! }
  Split.Left := Dirs.Left + Dirs.Width + 1;
  Split.Align := Dirs.Align; { give it the same alignment as the directory }
  { each pane must be at least one quarter of the forms width }
  Split.MinSize := Form1.ClientWidth div 4;
  { Finally, create the last pane  a file list box }
  Files := TFileListBox.Create(Form1);
  Files.Parent := Form1;
  Files.Align := alClient;
  Dirs.FileList := Files; { link the file list box to the directory list box }
end; 
