unit StringGridMouseToCell;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    procedure StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: StringGridMouseToCell
// Method: Grids.TCustomDrawGrid.MouseToCell

// BeginCode
{
This example uses a string grid on a form. When the user
selects a cell in the grid and releases the mouse button,
the column and row coordinates for the cell appear in the
cell. The code for displaying the coordinates is written in
the OnMouseUp event handler.  This example requires a
stringgrid.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  StringGrid1.DefaultColWidth := 100;
end;

procedure TForm1.StringGrid1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Column, Row: Longint;
begin
  StringGrid1.MouseToCell(X, Y, Column, Row);
  StringGrid1.Cells[Column, Row] := 'Col ' + IntToStr(Column) +
    ',Row ' + IntToStr(Row);
end;
// EndCode
// EndExample: StringGridMouseToCell
end.
