unit StringGridRows;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Button1: TButton;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: StringGridRows
// Property: Grids.TCustomGrid.Row
// Property: Grids.TStringGrid.Rows

// BeginCode
{
This example displays a string grid, a list box, and a
button on a form. When the application runs, strings are put
in the cells of row 1 of the string grid. When the user
clicks the button, The strings in the current row of the
grid are displayed in the list box.
Note that when the grid contains an empty cell, the list box
has a corresponding empty string.
} 
procedure TForm1.Button1Click(Sender: TObject);
begin
  ListBox1.Items := StringGrid1.Rows[StringGrid1.Row];
end;
procedure TForm1.FormCreate(Sender: TObject);
begin
  with StringGrid1 do
  begin
    Cells[1,0] := 'Column 1';
    Cells[2,0] := 'Column 2';
    Cells[3,0] := 'Column 3';
    Cells[4,0] := 'Column 4';
    Cells[0,1] := 'Row 1';
    Cells[1,1] := 'Object';
    Cells[2,1] := 'Pascal';
    Cells[3,1] := 'is';
    Cells[4,1] := 'excellent';
    Cells[0,2] := 'Row 2';
    Cells[1,2] := 'Delphi';
    Cells[2,2] := 'is';
    Cells[4,2] := 'RAD';
  end;
end;
// EndCode
// EndExample: StringGridRows
end.
