{
WndProc, WindowProc example
This example shows how to use the WndProc method and the WindowProc property to subclass a custom controls window procedure.  This example subclasses the window procedure of a TListBox descendant to respond to a user-defined message called WM_STYLEMESSAGE. The subclassed window procedure can be turned on or off by pressing a radio button.
} 
procedure TMyListBoxDescendant.SubClassWndProc(var Message: TMessage);
begin
  if Message.Msg = WM_STYLEMESSAGE then
    Style := TListBoxStyle(Message.WParam)
  else
    WndProc(Message);
end;
procedure TMyListBoxDescendant.ToggleSubClass(On: Boolean);
begin
  if On then
    WindowProc := SubClassWndProc;
  else
    WindowProc := WndProc;
end;
procedure TForm1.SubClassRadioGroup1Click(Sender: TObject);
begin
  MyListBoxDescendant1.ToggleSubClass(SubClassRadioGroup1.ItemIndex = 0);
end; 
