unit SubItemsEnabled;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Options1: TMenuItem;
    DisableSubItems: TButton;
    FileSub11: TMenuItem;
    FileSub21: TMenuItem;
    FileSub31: TMenuItem;
    ListBox1: TListBox;
    procedure Edit1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure DisableSubItemsClick(Sender: TObject);
    procedure FileSub11Click(Sender: TObject);
    procedure FileSub21Click(Sender: TObject);
    procedure FileSub31Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SubItemsEnabled
// Property: Menus.TMenuItem.Count
// Property: Menus.TMenuItem.Items
// Property: Menus.TMenuItem.Enabled

// BeginCode
{
The following code disables all the subitems of of the menu
item File1.  This example requires a button, a TMainMenu
with several menu items added, one of them named File1.
} 
procedure TForm1.DisableSubItemsClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to File1.Count - 1 do
    File1.Items[I].Enabled := False;
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  ListBox1.Items.Add('This is the Edit command');
end;

procedure TForm1.File1Click(Sender: TObject);
begin
  ListBox1.Items.Add('This is the File command');
end;

procedure TForm1.FileSub11Click(Sender: TObject);
begin
  ListBox1.Items.Add('This is the FileSub1 command');
end;

procedure TForm1.FileSub21Click(Sender: TObject);
begin
  ListBox1.Items.Add('This is the FileSub2 command');
end;

procedure TForm1.FileSub31Click(Sender: TObject);
begin
  ListBox1.Items.Add('This is the FileSub3 command');
end;

procedure TForm1.Options1Click(Sender: TObject);
begin
  ListBox1.Items.Add('This is the Options command');
end;
// EndCode
// EndExample: SubItemsEnabled
end.
