unit SysUtilsStrMove;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SysUtilsStrMove
// Routine: SysUtils.StrMove

// BeginCode
{
This example shows two functions that do the same thing as
StrNew and StrDispose.
}
function AHeapaString(S: PChar): PChar;
{ Allocate string on heap }
 var
  L: Cardinal;
  P: PChar;
  StrNew: PChar;
begin
  StrNew := nil;
  if (S <> nil) and (S[0] <> #0) then
  begin
    L := StrLen(S) + 1;
    GetMem(P, L);
    StrNew := StrMove(P, S, L);
  end;
  Result := StrNew;
end;

procedure DisposeDaString(S: PChar);
{ Dispose string on heap }
begin
  if S <> nil then FreeMem(S, StrLen(S) + 1);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  S, otherS: PChar;
begin
  S := 'Now you see it';
  otherS := AHeapaString(S);
  Canvas.TextOut(5, 10, otherS);
  Canvas.Refresh;
  Sleep(5000);
  DisposeDaString(otherS);
end;
// EndCode
// EndExample: SysUtilsStrMove
end.
