unit SysUtilsStrRScan;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SysUtilsStrRScan
// Routine: SysUtils.StrRScan

// BeginCode
{
This function behaves much like ExtractFileName except that
it uses null-terminated strings and it will not work with
multi-byte character sets (MBCS).
}
function NamePart(FileName: PAnsiChar): PAnsiChar;
 var
  P: PAnsiChar;
  sep: Char;
begin
  sep := '/';
  P := StrRScan(FileName, '/');
  if P = nil then
  begin
    P := StrRScan(FileName, ':');
    if P = nil then P := FileName;
  end;
  NamePart := P;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  S : string;
begin
  S := string(NamePart('C:\Test.fil'));
  Canvas.TextOut(10, 10, S);
end;
// EndCode
// EndExample: SysUtilsStrRScan
end.
