unit SysUtilsStrToFloat;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdConvs, ConvUtils, StdCtrls;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    Button1: TButton;
    Edit1: TEdit;
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Select(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SysUtilsStrToFloat
// Routine: SysUtils.StrToFloat
// Routine: ConvUtils.GetConvFamilies
// Routine: ConvUtils.DescriptionToConvFamily
// Routine: ConvUtils.ConvFamilyToDescription
// Routine: ConvUtils.GetConvTypes
// Routine: ConvUtils.DescriptionToConvType
// Routine: ConvUtils.ConvTypeToDescription
// Type: ConvUtils.TConvFamily
// Type: ConvUtils.TConvFamilyArray

// BeginCode
{
This example uses a form with a combo box, two list boxes,
an edit control, and a button.  The user selects a
conversion family from the combo box, which causes the list
boxes to fill with the conversion types registered with that
family. When the user clicks the button, a message box
appears showing the value in the edit control converted from
the units selected in the first list box to the units
selected in the second list box.
Note:	If you have not registered your own conversion families,
include the stdconvs unit in your uses clause to use the
standard conversion families.
}

{
The following OnCreate event handler for the form initializes
the combo box and list boxes:
}

procedure TForm1.FormCreate(Sender: TObject);
var
  FamilyList: TConvFamilyArray;
  i: Integer;
begin
  GetConvFamilies(FamilyList);
  for i := 0 to (Length(FamilyList) - 1) do
    ComboBox1.Items.Add(ConvFamilyToDescription(FamilyList[i]));
  ComboBox1.ItemIndex := 0; { select the first item }
  ComboBox1Select(ComboBox1); {trigger the event to initialize lists}
end;

{
The following OnClick event handler for the button reads the
value entered in the edit box and converts it between the
measurement units selected in the list boxes:
}
procedure TForm1.Button1Click(Sender: TObject);
var
  newVal: Double;
  CurFamily: TConvFamily;
  FromType, ToType: TConvType;
begin
  DescriptionToConvFamily(ComboBox1.Items[ComboBox1.ItemIndex], CurFamily);
  DescriptionToConvType(CurFamily, ListBox1.Items[ListBox1.ItemIndex], FromType);
  DescriptionToConvType(CurFamily, ListBox2.Items[ListBox2.ItemIndex], ToType);
  newVal := Convert(StrToFloat(Edit1.Text), FromType, ToType);
  ShowMessage(Format('%g %s', [newVal, ConvTypeToDescription(ToType)]));
end;

{
The following OnSelect event handler for the combo box
initializes the list boxes with the registered conversion
types for the selected family:
}
procedure TForm1.ComboBox1Select(Sender: TObject);
var
  TypeList: TConvTypeArray;
  i: Integer;
  CurFamily: TConvFamily;
  Description: string;
begin
  Description := ComboBox1.Items[ComboBox1.ItemIndex];
  if DescriptionToConvFamily(Description, CurFamily) then
  begin
    GetConvTypes(CurFamily, TypeList);
    ListBox1.Items.Clear;
    ListBox2.Items.Clear;
    for i := 0 to Length(TypeList) -1 do
      ListBox1.Items.Add(ConvTypeToDescription(TypeList[i]));
    ListBox2.Items := ListBox1.Items;
    ListBox1.ItemIndex := 0;
    ListBox2.ItemIndex := 0;
  end;
end;
// EndCode
// EndExample: SysUtilsStrToFloat
end.
