unit SystemAddr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Dialogs,
  Menus, Controls, StdCtrls, ComCtrls, Grids;

type
  TForm1 = class(TForm)
    TreeView1: TTreeView;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    StringGrid1: TStringGrid;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemAddr
// Routine: System.Addr

// BeginCode
{
This example uses the Addr function to get the address of a
numeric value that is stored as custom data in a tree node.
Once the assignment has been made, changes to the entries in
the NodeNumbers array can be read by dereferencing the
pointers that are stored in the Data property of the Tree
nodes.  This example requires a populated TreeView.
}

var
  NodeNumbers: array [0 .. 200] of String;

procedure TForm1.Button1Click(Sender: TObject);
var
  I : Integer;
 begin
  with TreeView1 do
  begin
    for I := 0 to Items.Count - 1 do
    begin
      NodeNumbers[I] := Items[I].Text;
      Items[I].Data := Addr(NodeNumbers[I]);
      StringGrid1.Cells[0, I + 1] := IntToStr(I);
      StringGrid1.Cells[1, I + 1] := IntToStr(Integer(Items[I].Data));
      StringGrid1.Cells[2, I + 1] := NodeNumbers[I];
    end;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  I : Integer;
  addr : Pointer;
begin
  I := StrToInt(Edit2.Text);
  addr := TreeView1.Items[I].Data;
  string(addr^) := Edit1.Text;  // NodeNumbers has been altered
  TreeView1.Items[I].Text := NodeNumbers[I]; // Update TreeView
  StringGrid1.Cells[2, I + 1] := NodeNumbers[I];  // Update StringGrid
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  StringGrid1.Cells[0, 0] := 'Node index';
  StringGrid1.Cells[1, 0] := 'Node addr';
  StringGrid1.Cells[2, 0] := 'Node text';
end;
// EndCode
// EndExample: SystemAddr
end.

