unit SystemAppend;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemAppend
// Routine: System.Append
// Routine: System.Flush

// BeginCode
{
Click the button and select a file to append a string to the bottom of the file.
}

procedure TForm1.Button1Click(Sender: TObject);
var
  f: TextFile;
begin
  if OpenDialog1.Execute then
  begin                    { open a text file }
    AssignFile(f, OpenDialog1.FileName);
    Append(f);
    Writeln(f, 'I am appending some stuff to the end of the file.'); 
    { insert code here that would require a Flush before closing the file }
    Flush(f);  { ensures that the text was actually written to file }
    CloseFile(f);
    MessageDlg(OpenDialog1.FileName + ' has been altered, please validate.', mtInformation, [mbOK], 0)
  end;
end;
// EndCode
// EndExample: SystemAppend
end.
