unit SystemArcTan;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit3: TEdit;
    Label3: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemArcTan
// Routine: System.ArcTan
// Property: System.Pi
// Routine: SysUtils.FloatToStr
// Routine: SysUtils.FloatToStrF

// BeginCode
{
This example shows how to use the ArcTan and FloatToStr
functions to approximate Pi.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  ex : Extended;
  mystring : String;
begin
  ex := 16 * ArcTan(1/5) - 4 * ArcTan(1/239); // Machin's formula
  mystring := FloatToStr(ex);
  Edit3.Text := mystring;
  Str(ex:25:23, mystring);
  Edit4.Text := mystring;
  mystring := FloatToStrF(ex, ffFixed, 35, 33);
  Edit2.Text := mystring;
  mystring := SysUtils.FormatFloat('#,##0.00000000000000000000000000;;Zero', ex);
  Edit5.Text := mystring;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  ex : Extended;
  myString : String;
begin
  ex := Pi;
//  mystring := FloatToStr(ex);
//  Str(ex:25:23, mystring);
  mystring := FloatToStrF(ex, ffFixed, 35, 33);
  Edit1.Text := mystring;
end;
// EndCode
// EndExample: SystemArcTan
end.
