unit SystemAssert;

interface

uses
  Windows, Messages, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

// BeginExample: SystemAssert
// Routine: System.Assert

// BeginCode
{
This example exercises the System Assert function.  The first
call passes and the second call fails.
}

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TStorage = class(TObject)
    FData: string;
    property Data: string read FData write FData;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure ModifyStorage(AStorage: TStorage; const s: string);
begin
  Assert(AStorage <> nil, '');
  AStorage.Data := s;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Storage: TStorage;
begin
  Storage := TStorage.Create;
  try
    ModifyStorage(Storage, 'Hello world');
  finally
    Storage.Free;
  end;

  // The following call is buggy and triggers the Assert
  ModifyStorage(nil, 'Ooops');
end;
// EndCode
// EndExample: SystemAssert
end.
