{
Assert example
}
program ShowAsserts;
{$APPTYPE CONSOLE}

{ Defining OLDSTYLE for the compilation allows old-style
  runtime error handling to occur rather than the new
  exception-based method. If the old style is used, then
  the user-supplied string is not displayed. }

{$IFNDEF OLDSTYLE}
uses SysUtils;
{$ENDIF}

type
  TStorage = class(TObject)
    FData: string;
    property Data: string read FData write FData;
  end;

procedure ModifyStorage(AStorage: TStorage; const s: string);
begin
  Assert(AStorage <> nil, '');
  AStorage.Data := s;
end;

var
  Storage: TStorage;
begin
  Storage := TStorage.Create;
  try
    ModifyStorage(Storage, 'Hello world');
  finally
    Storage.Free;
  end;

  // The following call is buggy and triggers the Assert
  ModifyStorage(nil, 'Ooops');
end. 
