unit SystemCos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ScrollBar1: TScrollBar;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Button1: TButton;
    Edit3: TEdit;
    procedure ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemCos
// Routine: System.Cos
// Routine: System.Round
// Routine: System.Dec

// BeginCode
{
This example displays the Cosine of any value between 0 and
12.  Since the scrollbar position is an integer between the
scrollbar  min and max, multiply the range and divide the
position to fine tune it.  With the scrollbar selected use
the left and right buttons to change the position by 1E-6.
Or use the Dec function to decrement (or increment) by a
specific amount.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  new : Integer;
begin
  new := ScrollBar1.Position;
  System.Dec(new, Round(StrToFloat(Edit3.Text)*1000000));
  ScrollBar1.Position := new;
  Edit1.Text := FloatToStr(ScrollBar1.Position/1000000);
  Edit2.Text := FloatToStr(Cos(ScrollBar1.Position/1000000));
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ScrollBar1.Max := Round(Pi * 4000000);   // 4 * Pi
end;

procedure TForm1.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  Edit1.Text := FloatToStr(ScrollPos/1000000);
  Edit2.Text := FloatToStr(Cos(ScrollPos/1000000));
end;
// EndCode
// EndExample: SystemCos
end.
