{
FileSize, Seek, FilePos example
This example displays a open dialog when the user clicks a button. When the user selects the file, it reports the size of the file, seeks to halfway through the file, and reports the file position at that point.
Note:	This example assumes the compiler flag $IOCHECKS ON ($I+). That is, it expects errors to generate exceptions rather than checking IOResult to be sure that I/O routines succeed.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
   f: file of Byte;
   size: Longint;
   S: string;
   y: Integer;
begin
  if OpenDialog1.Execute then
  begin
    AssignFile(f, OpenDialog1.FileName);
    Reset(f);
    try
      size := FileSize(f);
      S := 'File size in bytes: ' + IntToStr(size);
      y := 10;
      Canvas.TextOut(5, y, S);
      y := y + Canvas.TextHeight(S) + 5;
      S := 'Seeking halfway into file...';
      Canvas.TextOut(5, y, S);
      y := y + Canvas.TextHeight(S) + 5;
      Seek(f, size div 2);
      S := 'Position is now ' + IntToStr(FilePos(f));
      Canvas.TextOut(5, y, S);
    finally
      CloseFile(f);
    end;
  end;
end; 
