{
FreeMem example
The following example opens a file named 'test.txt' and reads the entire file into a dynamically allocated buffer. The buffer and the size of the file are then passed to a routine that processes the text, and finally the dynamically allocated buffer is freed and the file is closed.
} 
var
  F: file;
  Size: Integer;
  Buffer: PChar;
begin
  AssignFile(F, 'test.txt');
  Reset(F, 1);
  try
    Size := FileSize(F);
    GetMem(Buffer, Size);
    try
      BlockRead(F, Buffer^, Size);
      ProcessFile(Buffer, Size);
    finally
      FreeMem(Buffer);
    end;
  finally
    CloseFile(F);
  end;
end; 
