unit SystemIOResult;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemIOResult
// Routine: System.IOResult

// BeginCode
{
This example illustrates how to use IOResult to check the success of the Reset
method. If the call to Reset is successful, a message dialog displays the size
of the file that the user selects in an Open dialog. If the call to Reset fails,
a message warns the user that there was a file access error. To test the failure
part of this example, just misspell a file name in the open dialog.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  F: File of Byte;
begin
  if OpenDialog1.Execute then
  begin
    AssignFile(F, OpenDialog1.FileName);
    {$I-}
    Reset(F);
    {$I+}
    if IOResult = 0 then
    begin
      MessageDlg('File size in bytes: ' + IntToStr(FileSize(F)),
        mtInformation, [mbOk], 0);
      CloseFile(F);
    end
    else
      MessageDlg('File access error', mtWarning, [mbOk], 0);
  end;
end;
// EndCode
// EndExample: SystemIOResult
end.
