{
IOResult example
This example illustrates how to use IOResult to check the success of the Reset 
method. If the call to Reset is successful, a message dialog displays the size 
of the file that the user selects in an Open dialog. If the call to Reset fails,
a message warns the user that there was a file access error.
} 
var
  F: File of Byte;
begin
  if OpenDialog1.Execute then
  begin
    AssignFile(F, OpenDialog1.FileName);
    {$I-}
    Reset(F);
    {$I+}
    if IOResult = 0 then
    begin
      MessageDlg('File size in bytes: ' + IntToStr(FileSize(F)),
        mtInformation, [mbOk], 0);
      CloseFile(F);
    end
    else
      MessageDlg('File access error', mtWarning, [mbOk], 0);
  end;
end; 
