unit SystemLow;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    ListBox2: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemLow
// Routine: System.Low
// Routine: System.High

// BeginCode
{
This example requires a button and two list boxes.  Two lists
of floating point numbers are generated initially and
displayed in the list boxes. Clicking the button sums the lists.
Notice that the range of the list arrays can be any integers,
as long as Low is less than High.
}
var
  List1: array[0..3] of Double;
  List2: array[5..17] of Double;

function Sum( var X: array of Double): Double;
var
  I: Word;
  S: Real;
begin
  S := 0; { Note that open array index range is always zero-based. }
  for I := 0 to High(X) do S := S + X[I];
  Sum := S;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  S, TempStr: string;
begin
  Str(Sum(List1):4:2, S);
  S := 'Sum of List1: ' + S + #13#10;
  S := S + 'Sum of List2: ';
  Str(Sum(List2):4:2, TempStr);
  S := S + TempStr;
  MessageDlg(S, mtInformation, [mbOk], 0);

end;

procedure TForm1.FormCreate(Sender: TObject);
var
  X: Word;
begin
  for X := Low(List1) to High(List1) do
  begin
      List1[X] := X * 3.4;
      ListBox1.Items.Add(FloatToStr(List1[X]));
  end;
  for X := Low(List2) to High(List2) do
  begin
      List2[X] := X * 0.0123;
      ListBox2.Items.Add(FloatToStr(List2[X]));
  end;
end;
// EndCode
// EndExample: SystemLow
end.
