unit SystemMkDir;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemMkDir
// Routine: System.MkDir

// BeginCode
{
This example creates a directory using the path and directory name
entered in the text edit.  The path is relative to the project
directory.  Type in the name of an existing directory to induce the
error.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  {$I-}
  { Get directory name from TEdit control }
  MkDir(Edit1.Text);
  if IOResult <> 0 then
    MessageDlg('Cannot create directory', mtWarning, [mbOk], 0, mbOk)
  else
    MessageDlg('New directory created', mtInformation, [mbOk], 0, mbOk);
end;
// EndCode
// EndExample: SystemMkDir
procedure TForm1.FormCreate(Sender: TObject);
begin
  Edit1.Text := GetCurrentDir;
end;

end.
