unit SystemMove;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemMove
// Routine: System.Move

// BeginCode
{
This example moves characters from a Char array into an integer.
Displaying the integer as a hex, you can see that 'W' (0x57) is
stored in the least significant byte of the integer.
}
var
  A: array[1..4] of Char;
  B: Integer;

procedure DisplayAB;
begin
  Form1.ListBox1.Items[0] := A[1];
  Form1.ListBox1.Items[1] := A[2];
  Form1.ListBox1.Items[2] := A[3];
  Form1.ListBox1.Items[3] := A[4];
  Form1.Edit1.Text := IntToHex(B, 1);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Move(A, B, SizeOf(B));  { SizeOf = safety! }
  DisplayAB;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I : Integer;
begin
  A[1] := 'W';
  A[2] := 'H';
  A[3] := 'A';
  A[4] := 'T';
  B := 5;
  DisplayAB;
end;
// EndCode
// EndExample: SystemMove
end.
