unit SystemReset;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemReset
// Routine: System.Reset

// BeginCode
{
This example should be executed from a command line
formatted like this: "SystemReset_proj foo.txt".  The file
path is relative to the project directory.
}
function FileIsThere(FileName: string): Boolean;
{ Boolean function that returns True if the file exists; otherwise,
  it returns False. Closes the file if it exists. }
 var
  F: file;
begin
  {$I-}
  AssignFile(F, FileName);
  FileMode := 0;  {Set file access to read only }
  Reset(F);
  CloseFile(F);
  {$I+}
  FileIsThere := (IOResult = 0) and (FileName <> '');
end;  { FileIsThere }

procedure TForm1.Button1Click(Sender: TObject);
begin
  if FileIsThere(ParamStr(1)) then {Get file name from command line}
    Canvas.TextOut(10, 10, 'File exists')
  else
    Canvas.TextOut(10, 10, 'File not found');
end;
// EndCode
// EndExample: SystemReset
end.
