{
Reset example
}
function FileIsThere(FileName: string): Boolean;
{ Boolean function that returns True if the file exists; otherwise,
  it returns False. Closes the file if it exists. }
 var
  F: file;
begin
  {$I-}
  AssignFile(F, FileName);
  FileMode := 0;  {Set file access to read only }
  Reset(F);
  CloseFile(F);
  {$I+}
  FileIsThere := (IOResult = 0) and (FileName <> '');
end;  { FileIsThere }

begin
  if FileIsThere(ParamStr(1)) then {Get file name from command line}
    Canvas.TextOut(10, 10, 'File exists')
  else
    Canvas.TextOut(10, 10, 'File not found');
end; 
