unit SystemSeekEof;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemSeekEof
// Routine: System.SeekEof

// BeginCode
{
This example creates a file TEST.TXT, puts some text in it
and then reads the file to EOF.
}
procedure TForm1.Button1Click(Sender: TObject);
var
   f : System.TextFile;
   j, Y : Integer;
 begin
   AssignFile(f,'TEST.TXT');
   Rewrite(f);
   { Create a file with 8 numbers and some
     whitespace at the ends of the lines }
   Writeln(f,'1 2 3 4 ');
   Writeln(f,'5 6 7 8 ');
   Reset(f);
   { Read the numbers back. SeekEof returns TRUE if there is no 
     more text (other than whitespace) in the file. }
   Y := 5;
   while not SeekEof(f) do
   begin
     Read(f,j);
     Canvas.TextOut(5, Y, IntToStr(j));
     Y := Y + Canvas.TextHeight(IntToStr(j)) + 5;
   end;
 end;
// EndCode
// EndExample: SystemSeekEof
end.
