unit SystemSeekEoln;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SystemSeekEoln
// Routine: System.SeekEoln

// BeginCode
{
Create data with white space at beginning and end of line to
demonstrate that SeekEoln is immune to this.
}
procedure TForm1.Button1Click(Sender: TObject);
var
   f: System.TextFile;
   j, Y: Integer;
   s: string;
begin
   AssignFile(f,'TEST.TXT');
   Rewrite(f);

   Writeln(f, '    1 2 3 4      ');
   Writeln(f, 'Some text');

   Reset(f);
   Y := 5;

   while not SeekEoln(f) do // Will skip white space
   begin
     Read(f, j);
     Canvas.TextOut(5, Y, IntToStr(j));
     Y := Y + Canvas.TextHeight(IntToStr(j)) + 5;
   end;
   Readln(f); // Read line-end marker

   Readln(f, s); // Read string with line-end marker
   Canvas.TextOut(5, Y, s);
end;
// EndCode
// EndExample: SystemSeekEoln
end.
