{
StrLen, StrLCat example
The following example uses an edit control and a button 
on a form in an application. When the button is clicked, 
the edit controls text is split in halves that are 
copied into separate buffers. Then the contents of the 
buffers are displayed in a message box.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  FirstHalf: PChar;
  SecondHalf: PChar;
  HalfLen: Integer;
begin
  HalfLen := StrLen(PChar(string(Edit1.Text))) div 2;
  GetMem(FirstHalf,HalfLen+2);
  GetMem(SecondHalf,HalfLen+2);
  FirstHalf^ := Chr(0);
  SecondHalf^ := Chr(0);
  StrLCat(FirstHalf, PChar(string(Edit1.Text)), HalfLen);
  StrCat(SecondHalf, PChar(string(Edit1.Text)) + HalfLen);
  Application.MessageBox(FirstHalf, 'First Half', [smbOK], smsInformation, smbOK, smbCancel);
  Application.MessageBox(SecondHalf, 'Second Half', [smbOK], smsInformation, smbOK, smbCancel);
  FreeMem(FirstHalf);
  FreeMem(SecondHalf);
end; 
