unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: System_InitializeFinalize
// Routine: System.Initialize
// Routine: System.Finalize

// BeginCode
{
This example demonstrates the use of Initialize and Finalize functions
used to initialize and finalize a RTTI-enabled structure.
}
type
  { Declaring a data type that needs initilization }
  PPerson = ^TPerson;
  TPerson = record
    FFirstName: String;
    FLastName: String;
    FAge: Integer;
  end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Person: PPerson;
begin
  {
    Allocate a block of memory for the structure
    We're using an "unsafe" function: GetMem
    which doesn't use RTTI to initialize the
    strings inside the structure.
  }
  GetMem(Person, SizeOf(TPerson));

  { Initialize the structure in the Heap - RTTI will be used }
  Initialize(Person^);

  { Assign some data to the structure }
  Person.FFirstName := 'John';
  Person.FLastName := 'Smith';
  Person.FAge := 31;

  { Use RTTI to cleanup the internals of the structure }
  Finalize(Person^);
  FreeMem(Person);
end;
// EndCode
// EndExample: System_InitializeFinalize

end.
