unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: System_Ptr
// Routine: System.Ptr
// Routine: System.UniqueString

// BeginCode
{
The following code demostrates the use of Ptr function. The example
makes use of Ptr to simulate pointer arithmetics.
}
function FastUpperCase(const S: String): String;
var
  C: ^Char;
  I: Integer;
begin
  { Get the text in the edit box }
  Result := S;

  { Ensure the string reference stored in Result is unique,
    otherwise we may change the original string also.
    No copy-on-write is done if we're accesing the character
    directly.
  }
  UniqueString(Result);

  { Find the address of the first char in the string }
  C := Addr(Result[1]);

  for I := 0 to Length(Result) - 1 do
  begin
    { Up-case the character }
    C^ := UpCase(C^);

    { Move to the next character }
    C := Ptr(Integer(C) + SizeOf(Char));
  end;
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  { Uppercase the string in the edit box }
  Edit1.Text := FastUpperCase(Edit1.Text);
end;
// EndCode
// EndExample: System_Ptr

end.
