unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: System_ReallocMem
// Routine: System.ReallocMem
// Routine: System.SetString
// Routine: System.MoveChars

// BeginCode
{
The following code demostrates the use of ReallocMem function. Three
edit boxes and a button are expected onthe form.
}
function FastStrCat(const S1, S2: String): String;
var
  FinalStr: PChar;
begin
  {
   Allocated enough space in FinalStr to copy the contents
   of the initial string + $00 character
  }
  GetMem(FinalStr, (Length(S1) + 1) * SizeOf(Char));

  { Copy the contents of the first string }
  MoveChars(S1[1], FinalStr^, Length(S1) + 1);

  { And now expand the final string + $00 character }
  ReallocMem(FinalStr, (Length(S1) + Length(S2) + 1) * SizeOf(Char));

  { Copy the contents of the second string }
  MoveChars(S2[1], FinalStr[Length(S1)], Length(S2) + 1);

  { Get the result in String }
  SetString(Result, FinalStr, Length(S1) + Length(S2));
  FreeMem(FinalStr);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  { Concatenate 2 string }
  Edit3.Text := FastStrCat(Edit1.Text, Edit2.Text);
end;
// EndCode
// EndExample: System_ReallocMem

end.
