unit TActionOnExecute;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AppEvnts, ActnList, Menus, StdCtrls, ToolWin, ComCtrls;

// BeginExample: TActionOnExecute
// Event: Classes.TBasicAction.OnExecute

// BeginCode
{
When a client component or control is clicked, the OnExecute
event occurs for its associated action. For example, the
following code illustrates the OnExecute event handler for
an action that toggles the visibility of a toolbar when the
action is executed. This example requires a TActionList
(with one TAction) and a TToolBar on a form.  Double click
on the TActionList and create an TAction named Action1.  The
TActionList must have no OnExecute event handler, and the
TAction has an OnExecute event handler called Action1Execute.
Then set an object's (such as a button or menu item) Action
to Action1.
}
type
  TMainForm = class(TForm)
    ActionList: TActionList;
    Action1: TAction;
    MainMenu: TMainMenu;
    MenuAction: TMenuItem;
    lbOther: TListBox;
    lblOther: TLabel;
    ToolBar1: TToolBar;
    procedure Action1Execute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

procedure TMainForm.Action1Execute(Sender: TObject);
begin
	{ Toggle Toolbar1s visibility }
	ToolBar1.Visible := not ToolBar1.Visible;
  if ToolBar1.Visible then
    lbOther.Items.Add('Event Action1Execute: toolbar visible')
  else
    lbOther.Items.Add('Event Action1Execute: toolbar not visible')
end;
// EndCode
// EndExample: TActionOnExecute

end.
