unit TActionOnUpdate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AppEvnts, ActnList, Menus, StdCtrls, ToolWin, ComCtrls;

type
  TMainForm = class(TForm)
    ActionList: TActionList;
    Action1: TAction;
    lbOther: TListBox;
    lblOther: TLabel;
    ToolBar1: TToolBar;
    Button1: TButton;
    procedure Action1Update(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

// BeginExample: TActionOnUpdate
// Event: Classes.TBasicAction.OnUpdate
// Property: ActnList.TCustomAction.Checked

// BeginCode
{
When the application is idle, the OnUpdate event occurs for
every action that is linked to a visible control or menu
item that is showing. This provides an opportunity for
applications to execute centralized code for enabling and
disabling, checking and unchecking, and so on. For example,
the following code illustrates the OnUpdate event handler
for an action that is "checked" when the toolbar is visible.
This example requires a TActionList (with one TAction) and a
TToolBar on a form. This example requires a TActionList
(with one TAction) and a TToolBar on a form.  Double click
on the TActionList and create an TAction named Action1.  The
TAction has an OnUpdate event handler called Action1Update.
Then set an object's (such as a button or menu item) Action
to Action1.
}
procedure TMainForm.Action1Update(Sender: TObject);
begin
  if ((Sender as TAction).Checked <> ToolBar1.Visible) then
    lbOther.Items.Add('Event Action1Update: toolbar visibility changed');
	{ Indicate whether ToolBar1 is currently visible }
	(Sender as TAction).Checked := ToolBar1.Visible;
end;
// EndCode
// EndExample: TActionOnUpdate

procedure TMainForm.Button1Click(Sender: TObject);
begin
	{ Toggle Toolbar1s visibility }
	ToolBar1.Visible := not ToolBar1.Visible;
  if ToolBar1.Visible then
    lbOther.Items.Add('Toolbar is visible')
  else
    lbOther.Items.Add('Toolbar is not visible')
end;

end.
