{
OnUpdate, Checked example
When the application is idle, the OnUpdate event occurs for every action that is linked to a visible control or menu item that is showing. This provides an opportunity for applications to execute centralized code for enabling and disabling, checking and unchecking, and so on. For example, the following code illustrates the OnUpdate event handler for an action that is checked when the toolbar is visible. This example requires a TActionList (with one TAction) and a TToolBar on a form.
} 
procedure TForm1.Action1Update(Sender: TObject);
begin
	{ Indicate whether ToolBar1 is currently visible }
	(Sender as TAction).Checked := ToolBar1.Visible;
end; 
