program TAppCreateForm_proj;

uses
  Forms, SysUtils,
  TAppCreateForm in 'TAppCreateForm.pas' {Form1},
  TAppCreateForm2 in 'TAppCreateForm2.pas' {Form2},
  TAppCreateForm3 in 'TAppCreateForm3.pas' {Form3},
  TAppCreateForm4 in 'TAppCreateForm4.pas' {Form4},
  TAppCreateForm5 in 'TAppCreateForm5.pas' {Form5};

{$R *.res}

// BeginExample: TAppCreateForm
// Method: Forms.TApplication.CreateForm
// Method: ComCtrls.TProgressBar.StepBy
// Method: Forms.TApplication.Run
// Method: Forms.TCustomForm.Show
// Method: Controls.TWinControl.Update
// Method: Forms.TApplication.Initialize
// Property: Forms.TApplication.MainFormOnTaskBar

// BeginCode
{
This example shows progress of loading forms as an
application starts up. The code example is placed in the
project source (*.dpr) file.  To see project source, right
click on the executable file in the Project Manager and
select the View Source menu item.  You will need to set up
your project with the following steps before using the code
example:
	Add four additional forms to a default project. 
	Place a TProgressBar on Form5
	Take the Project|Options|Forms menu option and place 
          Form5 on the available forms list.
	Change the code of your project (*.dpr) file to look
          like the example.
}
begin
  Application.Initialize;
  with TForm5.Create(nil) do
  try
    Application.MainFormOnTaskbar := True;
    ProgressBar1.Max := 100;
    Show;  // show a splash screen contain ProgressBar control
    Update; // force display of Form5
    Application.CreateForm(TForm1, Form1);
    ProgressBar1.StepBy(25);
    Label1.Caption :=  'Form1 loaded successfully.';
    Update; // force display of Form5
    Sleep(3000);
    Application.CreateForm(TForm2, Form2);
    ProgressBar1.StepBy(25);
    Label1.Caption :=  'Form2 loaded successfully.';
    Update; // force display of Form5
    Sleep(3000);
    Application.CreateForm(TForm3, Form3);
    ProgressBar1.StepBy(25);
    Label1.Caption :=  'Form3 loaded successfully.';
    Update; // force display of Form5
    Sleep(3000);
    Application.CreateForm(TForm4, Form4);
    ProgressBar1.StepBy(25);
    Label1.Caption :=  'Form4 loaded successfully.';
    Update; // force display of Form5
    Sleep(3000);
  finally
    Free;
  end;
  Application.Run;
// EndCode
// EndExample: TAppCreateForm
end.
