{
Note:	It is not actually necessary to write an OnHint 
event handler to display hints on the status bar. This can 
be accomplished more simply by setting the status bars 
AutoHint property.
}
{ This shows how the OnHint event handler is declared as a 
public method of the form }
type
  TForm1 = class(TForm)
    Button1: TButton;
    StatusBar1: TStatusBar;
    Edit1: TEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    procedure DisplayHint(Sender: TObject);
  end;
var
  Form1: TForm1;
implementation
{$R *.xfm}

{ Here is the implementation of the OnHint event handler }
{ It displays the applications current hint in the status bar }
procedure TForm1.DisplayHint(Sender: TObject);
begin
  StatusBar1.SimpleText := GetLongHint(Application.Hint);
end;
{ Here is the forms OnCreate event handler. }
{ It assigns the applications OnHint event handler at runtime }
{ because the Application is not available in the Object Inspector }
{ at design time }
procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnHint := DisplayHint;
end;
