unit TAppOnHelp;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    function AppHelp(Command: Word; Data: Longint; var CallHelp: Boolean) : Boolean;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: TApplicationOnHelp
// Event: Forms.TApplication.OnHelp
// Property: Forms.TApplication.HelpFile

// Warning: Called HelpContext to invoke AppHelp, but not from FormCreate.
// Warning: No online help for this app, so just put up a dialog box to show what HLP file it's using.

// BeginCode
{
The following code changes the Help file depending on the
active form, before the help viewer is called. AppHelp is
assigned to the OnHelp event handler of Application in the
OnCreate event of Form1.
}
function TForm1.AppHelp(
  Command: Word; Data: Longint; var CallHelp: Boolean) : Boolean;
var helpstring : String;
begin
  helpstring := Screen.ActiveForm.Name + '.hlp';
  MessageDlg(
    'Using ' + helpstring + ' as the help file.',
    mtInformation, [mbOK], 0);
  Application.HelpFile := helpstring;
  CallHelp := True;
end;

procedure TForm1.Button1Click(Sender: TObject);
const DATANOTFOUND = 714;
begin
  Application.HelpContext(DATANOTFOUND);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnHelp := AppHelp;
end;
// EndCode
// EndExample: TApplicationOnHelp
end.
